extern crate sdl2;

mod font;

pub mod generated;
mod interpolation;
#[cfg(all(feature = "music", not(feature = "32k")))]
mod music;
mod render;
pub mod vendored;

use std::time::{Duration, SystemTime};

#[cfg(all(feature = "music", not(feature = "32k")))]
use music::{mmc2r_to_pcm, Music};
use sdl2::{event::Event, keyboard::Keycode};

#[cfg(all(not(feature = "notimeout"), not(feature = "32k")))]
const TIMEOUT_DEATH: f64 = render::JUST_DVD + 24.0;

use sdl2::audio::AudioSpecDesired;

#[cfg(all(feature = "music", not(feature = "32k")))]
use vendored::micromod::MmC2r;

pub fn main() {
  let sdl_context = sdl2::init().unwrap();

  #[cfg(all(feature = "music", not(feature = "32k")))]
  let audio_subsystem = sdl_context.audio().unwrap();

  #[cfg(all(feature = "music", not(feature = "32k")))]
  let desired_spec = AudioSpecDesired {
    freq: Some(48_000),
    #[cfg(feature = "stereo")]
    channels: Some(2),
    #[cfg(not(feature = "stereo"))]
    channels: Some(1),
    samples: Some(8192 as u16),
  };

  #[cfg(all(feature = "music", not(feature = "32k")))]
  let device = audio_subsystem
    .open_playback(None, &desired_spec, |spec| {
      // initialize the audio callback
      Music {
        offset: 0,
        pcm: mmc2r_to_pcm(
          &mut MmC2r::new(include_bytes!("../uwudhd.mod"), spec.freq as isize).unwrap(),
        ),
        playing: true,
      }
    })
    .unwrap();

  // Start playback
  #[cfg(all(feature = "music", not(feature = "32k")))]
  device.resume();

  let video_subsystem = sdl_context.video().unwrap();

  let mut builder = video_subsystem.window("cosin25-invite.rs", 1280 / 2, 800 / 2);
  builder.position_centered();
  #[cfg(feature = "fullscreen")]
  builder.fullscreen_desktop();
  #[cfg(feature = "resizable")]
  builder.resizable();
  let window = &mut builder.build().unwrap();
  window.set_minimum_size(1280 / 2, 800 / 2).unwrap();

  let mut canvas = window.clone().into_canvas().build().unwrap();
  let texture_creator = canvas.texture_creator();

  #[cfg(feature = "logical")]
  canvas.set_logical_size(1280 / 2, 800 / 2).unwrap();

  render::render(&mut canvas, &texture_creator, 0.001);

  canvas.present();
  let mut event_pump = sdl_context.event_pump().unwrap();

  let start_time = SystemTime::now();
  'running: loop {
    let time = SystemTime::now()
      .duration_since(start_time)
      .expect("Time went back between frames");
    let time = f64::from(time.as_millis() as u32) / 1000.0;
    // let time = time * 2.0;

    #[cfg(all(not(feature = "notimeout"), not(feature = "32k")))]
    if time > TIMEOUT_DEATH {
      break 'running;
    }

    render::render(&mut canvas, &texture_creator, time);

    for event in event_pump.poll_iter() {
      match event {
        Event::Quit { .. }
        | Event::KeyDown {
          keycode: Some(Keycode::Escape),
          ..
        } => break 'running,
        _ => {}
      }
    }
    // The rest of the game loop goes here...
    canvas.present();
    ::std::thread::sleep(Duration::new(0, 1_000_000_000u32 / 12000));
  }
}
